


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* function prototypes */

void main(int argc,char *argv[]);

/* file structure definition */

typedef struct
{
    char fType[12];
    int intWidth;
    int intExt;
    int chnRec;
    int hGain;
    int leftBin;
    int fpMode;
    int bottomRef;
    int vGain;
    float fBottom;
    float fScrn;
    float datMin;
    float datRng;
    unsigned long recCount;
} traceFileHdr;

/* trace buffer */

int traceBuffer[17000];


void main(int argc,char *argv[])
{
    FILE *inp_f,*out_f;
    traceFileHdr tf;
    float a;
    int i;

    if (argc!=3)  {
        printf("\nUsage: bintoasc <input file> <output file>\n\n");
        exit (2);
    }

    inp_f = fopen(argv[1],"rb");
    out_f = fopen(argv[2],"w");
    if (inp_f==NULL)  {
        printf("\nCannot open input file!\n\n");
        exit (2);
    }
    if (out_f==NULL)  {
        printf("\nCannot open output file!\n\n");
        exit (2);
    }

    /* get file header */

    if (fread(&tf,sizeof(traceFileHdr),1,inp_f) != 1)   {
        printf("\nError reading file header!\n\n");
        exit (2);
    }

    /* get trace buffer */

    if (fread(traceBuffer,sizeof(int),1024*tf.chnRec,inp_f)!=1024*tf.chnRec) {
        printf("\nError reading file data!\n\n");
        exit (2);
    }

    /* check id string */

    if (strncmp(tf.fType,"SR430_TRACE\x1a",11))  {
        printf("\nNot a trace file!\n\n");
        exit (2);
    }

    for (i=0;i<1024*tf.chnRec;i++)  {
        if (!tf.fpMode)
            a = (float)traceBuffer[i];
        else
            a = (float) (unsigned) traceBuffer[i]*tf.datRng/65535.0 + tf.datMin;

        fprintf(out_f,"%d\t\t%e\n",i,a);
    }
    fcloseall();
    printf("\nSuccessfully converted file %s\n\n",argv[1]);
}

